/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class VWQubbleSort {
    public static synchronized void sort(Object[] a, int lo0, int hi0) throws Exception {
        int hi = hi0;
        int lo = lo0;
        if (hi - lo <= 6) {
            VWQubbleSort.bsort(a, lo, hi);
            return;
        }
        Object pivot = a[(int)((long)(lo + hi) / 2L)];
        a[(lo + hi) / 2] = a[hi];
        a[hi] = pivot;
        while (lo < hi) {
            while (VWQubbleSort.compareTo(a[lo], pivot) <= 0 && lo < hi) {
                ++lo;
            }
            while (VWQubbleSort.compareTo(pivot, a[hi]) <= 0 && lo < hi) {
                --hi;
            }
            if (lo >= hi) continue;
            Object T = a[lo];
            a[lo] = a[hi];
            a[hi] = T;
        }
        a[hi0] = a[hi];
        a[hi] = pivot;
        VWQubbleSort.sort(a, lo0, lo - 1);
        VWQubbleSort.sort(a, hi + 1, hi0);
    }

    public static synchronized void sort(Object[] a) throws Exception {
        VWQubbleSort.sort(a, 0, a.length - 1);
    }

    public static synchronized int compareTo(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null ? 0 : -1;
        }
        if (obj2 == null) {
            return 1;
        }
        String name1 = null;
        String name2 = null;
        if (obj1 instanceof String && obj2 instanceof String) {
            name1 = (String)obj1;
            name2 = (String)obj2;
        } else if (obj1 instanceof IVWSortItem && obj2 instanceof IVWSortItem) {
            name1 = ((IVWSortItem)obj1).getName();
            name2 = ((IVWSortItem)obj2).getName();
        } else {
            name1 = VWQubbleSort.getName(obj1);
            name2 = VWQubbleSort.getName(obj2);
        }
        return VWStringUtils.compareIgnoreCase(name1, name2);
    }

    public static synchronized String getName(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            Object result;
            Method getNameMethod = obj.getClass().getMethod("getName", null);
            if (getNameMethod != null && (result = getNameMethod.invoke(obj, null)) != null && result instanceof String) {
                return (String)result;
            }
        }
        catch (NoSuchMethodException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return obj.toString();
    }

    private static synchronized void bsort(Object[] a, int lo, int hi) throws Exception {
        for (int j = hi; j > lo; --j) {
            for (int i = lo; i < j; ++i) {
                if (VWQubbleSort.compareTo(a[i], a[i + 1]) <= 0) continue;
                Object T = a[i];
                a[i] = a[i + 1];
                a[i + 1] = T;
            }
        }
    }
}

